function [L,gamma_e] = Step2_Observer_design(A,F,C,D,Ce)

[n,q] = size(F);
[~,l] = size(D);
[p,~] = size(C);

% Augmented system
A_bar = [A F zeros(n,q); zeros(q,n) zeros(q,q) eye(q); zeros(q,n) zeros(q,q) zeros(q,q)];
C_bar = [C zeros(p,q) zeros(p,q)];
D_bar = [D zeros(n,q); zeros(q,l) zeros(q,q); zeros(q,l) eye(q)];

Q = sdpvar(n+2*q,n+2*q);
Y = sdpvar(n+2*q,p);
gamma = sdpvar(1,1);

LMI1 = blkvar();
LMI1(1,1) = (Q*A_bar-Y*C_bar)+(Q*A_bar-Y*C_bar)';
LMI1(1,2) = Q*D_bar;
LMI1(1,3) = Ce';

LMI1(2,2) = -gamma*eye(l+q);

LMI1(3,3) =-gamma*eye(n+2*q);

LMI1 = sdpvar(LMI1);

obj = 1.0e-7*gamma;
const = [];

const = [const, gamma >= eps];
const = [const, Q >= eps*eye(n+2*q)];
const = [const, LMI1 <= -eps*eye(2*n+5*q+l)]; 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5
ops = sdpsettings('solver','mosek','verbose',1);
optimize(const,obj,ops);

L = inv(value(Q))*value(Y);
gamma_e = value(gamma);


